package lrs.visitor;

import counter.*;
import lrs.*;

/**
* Removes and returns the nth element in a LRS.
*/
public class RemoveNth implements IAlgo, ICounterAlgo {

 public static RemoveNth Singleton = new RemoveNth();

 private RemoveNth(){}
 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object zeroCase(Counter host, Object param)
 {
  // param is the host of the null/nonNull cases.
  return (((LRStruct)param).removeFirst ());
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object nonZeroCase(Counter host, Object param)
 {
  return (((LRStruct) param).getRest ().execute (this, host.decrement ()));
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object nullCase(LRStruct host, Object param)
 {
  return (null); // No such element exists.
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object nonNullCase(LRStruct host, Object param)
 {
  return (((Counter) param).execute(this, host)); //
 }

}

